/*
 * Demonstration how to "inherit" and extend AMFIO_SERVER()
 * You can do basically the same with AMFWS_SERVER()
 *
 */

#include "hbthread.ch"
#include "hbsocket.ch"

MEMVAR Mutex, Connections

   THREAD STATIC s_dtStart

FUNCTION MY_AMFIO_MTSERVER( nPort, cIfAddr, hAnonFuncs, lUserControl, symConvIn, symConvOut, lObjectExt )

   LOCAL pListenSocket

   IF !Empty( lObjectExt )
      IF HB_IsLogical( symConvIn ) .AND. symConvIn
         symConvIn := @AMFIO_ObjConvIn()
      ENDIF
      IF HB_IsLogical( symConvOut ) .AND. symConvOut
         symConvOut := @AMFIO_ObjConvOut()
      ENDIF
   ELSE
      IF !HB_IsSymbol( symConvIn )
         symConvIn := NIL
      ENDIF
      IF !HB_IsSymbol( symConvOut )
         symConvOut := NIL
      ENDIF
   ENDIF

   IF HB_MTVM()
      
      s_lExit := .F.
      
      pListenSocket := HB_SocketOpen()
      IF ! HB_SocketBind( pListenSocket, { HB_SOCKET_AF_INET, cIfAddr, nPort } )
         Alert( "AMFIO", "bind() error " + HB_NtoS( HB_SocketGetError() ) )
         RETURN - 1
      ELSEIF ! HB_SocketListen( pListenSocket )
         Alert( "AMFIO", "listen() error" + HB_NtoS( HB_SocketGetError() ) )
         RETURN - 1
      ENDIF

      HB_ThreadDetach( HB_ThreadStart( HB_THREAD_INHERIT_PUBLIC, @AMFIO_SRVLOOP(), pListenSocket, @MY_AMFIO_SERVER(), hAnonFuncs, lUserControl, symConvIn, symConvOut, lObjectExt ) )

   ENDIF

   RETURN pListenSocket

PROCEDURE MY_AMFIO_SERVER( pConnectionSocket, hAnonFuncs, lUserControl, symConvIn, symConvOut, lObjectExt )

   LOCAL nConnId, aConnections, aPeer
   LOCAL i, cClientName := "AMFIO:"

   aPeer := HB_SocketGetPeerName( pConnectionSocket )

   HB_MutexLock( Mutex )
   aConnections := Connections
   FOR i := 1 TO Len( aConnections )
      IF aConnections[ i ] = NIL
         aConnections[ i ] := { cClientName, pConnectionSocket, HB_ThreadSelf(), NIL, aPeer[2] + ":" + HB_NtoS( aPeer[3] ) }
         nConnId := i
         EXIT
      ENDIF
   NEXT
   IF Empty( nConnId )
      AAdd( aConnections, { cClientName, pConnectionSocket, HB_ThreadSelf(), NIL, aPeer[ 2 ] + ":" + HB_NtoS( aPeer[ 3 ] ) } )
      nConnId := Len( aConnections )
   ENDIF

   RPC_StartSession()
   AMFIO_SERVER( pConnectionSocket, hAnonFuncs, lUserControl, symConvIn, symConvOut, lObjectExt )

   HB_MutexLock( Mutex )
   Connections[ nConnId ] := NIL
   HB_MutexUnlock( Mutex )

   RETURN

STATIC PROCEDURE RPC_StartSession()

   // example how to store some session information in statics
   s_dtStart := HB_DateTime()

   RETURN

FUNCTION RPC_Started()

   RETURN s_dtStart
