/*******
*
*  amfio.ch
*
*  Aleksander Czajczynski <hb/at/fki.pl> 2011
*
*  amfio.ch - AMF3 Harbour headers
*
*
********/

#ifndef _HBAMF_CH
#define _HBAMF_CH

#define AMF3_UNDEFINED 0x00
#define AMF3_NULL 0x01
#define AMF3_FALSE 0x02
#define AMF3_TRUE 0x03
#define AMF3_INTEGER 0x04
#define AMF3_DOUBLE 0x05
#define AMF3_STRING 0x06
#define AMF3_XMLDOC 0x07
#define AMF3_DATE 0x08
#define AMF3_ARRAY 0x09
#define AMF3_OBJECT 0x0A
#define AMF3_XML 0x0B

#define CHR_AMF3_UNDEFINED HB_BChar( AMF3_UNDEFINED )
#define CHR_AMF3_NULL HB_BChar( AMF3_NULL )
#define CHR_AMF3_FALSE HB_BChar( AMF3_FALSE )
#define CHR_AMF3_TRUE HB_BChar( AMF3_TRUE )
#define CHR_AMF3_INTEGER HB_BChar( AMF3_INTEGER )
#define CHR_AMF3_DOUBLE HB_BChar( AMF3_DOUBLE )
#define CHR_AMF3_STRING HB_BChar( AMF3_STRING )
#define CHR_AMF3_XMLDOC HB_BChar( AMF3_XMLDOC  )
#define CHR_AMF3_DATE HB_BChar( AMF3_DATE )
#define CHR_AMF3_ARRAY HB_BChar( AMF3_ARRAY )
#define CHR_AMF3_OBJECT HB_BChar( AMF3_OBJECT )
#define CHR_AMF3_XML HB_BChar( AMF3_XML )

#define AMFIO_PROCEXISTS 8
#define AMFIO_PROCEXEC 9 
#define AMFIO_FUNCEXEC 10
#define AMFIO_OBJECTNEW 16
#define AMFIO_OBJECTDEL 17
#define AMFIO_OBJECTWITH 18
#define AMFIO_OBJECTSEND 19
#define AMFIO_OBJECTGETV 20
#define AMFIO_WAREQUEST 32

#define AMFIO_MAXREFID 65535

#define BLOCK_SIZE 500

#endif
