/**
 * Top level entry to AMF library for Node JS
 */

var amf = { };

 
/**
 * @return AMFPacket
 */
amf.packet = function( src ){
	var Packet;
	if( src ){
		Packet = AMFPacket.deserialize( src );
	}
	if( ! Packet ){
		Packet = new AMFPacket;
	}
	return Packet;
}


/**
 * @return AMFMessage
 */
amf.message = function( value, requestURI, responseURI ){
	return new AMFMessage( value, requestURI, responseURI );
}


/**
 * @return AMFHeader
 */
amf.header = function( value, requestURI, responseURI ){
	return new AMFMessage( value, requestURI, responseURI );
}
 

/**
 * @return AMFDeserializer
 */ 
amf.deserializer = function( src ){
	return new AMFDeserializer( src );
}  


/**
 * @return AMFSerializer
 */ 
amf.serializer = function(){
	return new AMFSerializer( 3 );
} 


/**
 * @return AMFTraits
 */
amf.traits = function(){
	return new AMFTraits;
}


/**
 * pseudo constants
 */

amf.AMF0 = 0;
amf.AMF3 = 3;
// AMF0 markers
amf.AMF0_NUMBER = 0;
amf.AMF0_BOOLEAN = 1;
amf.AMF0_STRING = 2;
amf.AMF0_OBJECT = 3;
amf.AMF0_MOVIECLIP = 4;
amf.AMF0_NULL = 5;
amf.AMF0_UNDEFINED = 6;
amf.AMF0_REFERENCE = 7;
amf.AMF0_ECMA_ARRAY = 8;
amf.AMF0_OBJECT_END = 9;
amf.AMF0_STRICT_ARRAY = 0x0A;
amf.AMF0_DATE = 0x0B;
amf.AMF0_LONG_STRING = 0x0C;
amf.AMF0_UNSUPPORTED = 0x0D;
amf.AMF0_RECORDSET = 0x0E;
amf.AMF0_XML_DOC = 0x0F;
amf.AMF0_TYPED_OBJECT = 0x10;
amf.AMF0_AMV_PLUS = 0x11;
// AMF3 markers
amf.AMF3_UNDEFINED = 0;
amf.AMF3_NULL = 1;
amf.AMF3_FALSE = 2;
amf.AMF3_TRUE = 3;
amf.AMF3_INTEGER = 4;
amf.AMF3_DOUBLE = 5;
amf.AMF3_STRING = 6;
amf.AMF3_XML_DOC = 7;
amf.AMF3_DATE = 8;
amf.AMF3_ARRAY = 9;
amf.AMF3_OBJECT = 0x0A;
amf.AMF3_XML = 0x0B;
amf.AMF3_BYTE_ARRAY = 0x0C;
