/*
 * constant-like variables
 */

AMFIO_PROCEXISTS = 8;
AMFIO_PROCEXEC = 9; 
AMFIO_FUNCEXEC = 10;
AMFIO_OBJECTNEW = 16;
AMFIO_OBJECTDEL = 17;
AMFIO_OBJECTWITH = 18;
AMFIO_OBJECTSEND = 19;
AMFIO_OBJECTGETV = 20;
      
AMFIO_MAXREFID = 65535; 

/*
 * amfIO class
 */ 

function AmfIO( socket )
{
   this.refIDs = new Array( AMFIO_MAXREFID );
   this.lastRefID = 0;
   this.selectedObjectID;
   this.socket = socket;
   socket.binaryType = 'arraybuffer';

   this.sendPacket = function( type, responder /* , ... args */ )
   {
      var args = Array.prototype.slice.call( arguments );
      var checksum;
      var data = '';
      var seri = amf.serializer();
      var parser = bin.parser( false, true );

      try
      {
         data += parser.fromByte( type );
         if( type != AMFIO_PROCEXEC )
            data = this.genRefID( data, parser, responder );
        
         args.splice( 0, 2 );
         data += seri.writeValue( args );

         checksum = 0;
         for( var i = 0; i < data.length; i++ )
         {
            checksum ^= data.charCodeAt(i);
         }
            
         data += parser.fromByte( checksum );

         // how to check if current socket is a text socket!
         // if( socket.text )
         // self-answer: it's determined by the type we supply to send method
         // data = btoa( data ); // Base64 encoding for text frames

         this.socket.send( this.str2AB( data ) );
      }
      catch ( err )
      {
        // amfioEvent.result = response;
      }
   };

   this.genRefID = function( data, parser, responder )
   {
      var skipped = 0;
         
      do
      {
         if( this.lastRefID >= AMFIO_MAXREFID )
            this.lastRefID = 1;
         else
            this.lastRefID++;

         if( ++skipped == AMFIO_MAXREFID )
            throw new Error("request reference ID's exhausted");
                        
      } while ( this.refIDs[ this.lastRefID ] != null );

      if( responder != null )
         this.refIDs[ this.lastRefID ] = responder;
      else
         this.refIDs[ this.lastRefID ] = true;

      data += parser.fromWord( this.lastRefID );
      return data;
   }

   this.processPacket = function( data )
   {
      var parser = bin.parser( false, true );
      var refID;
      var checksum;
      var deseri;
      var response;
      var compchecksum = 0;
      var decision;
      // var amfioEvent;

      if( data instanceof ArrayBuffer )
         data = this.AB2str( data );
      else if( data === "string" )
         data = atob( data ); 
      else
         throw new Error("Unexpected datatype: " + typeof data );

      refID = parser.toWord( data.slice( 0, 3 ) );
      checksum = parser.toByte( data.slice( -1 ) );

      for( var i = 0; i < data.length - 1; i++ )
         compchecksum ^= data.charCodeAt(i);

      if( compchecksum == checksum )
      {
         data = data.slice( 2, -1 );
         deseri = amf.deserializer( data );
         response = deseri.readValue( 3 );

         if( !response )
         {
            // amfioEvent.result = "Response is null";
            // this.dispatchEvent(amfioEvent);
         }
         else if( 'amfIOProxy' === typeof response )
            response.setOwner( this );
               
         var responder = this.refIDs[ refID ];
         if( 'function' === typeof responder )
         {
            // amfioEvent.handled = true;
            decision = responder( response );
            if( 'boolean' === typeof decision ) 
            {
               if( decision )
                  this.refIDs[ refID ] = null;
               // else if responder returns a false value, then it's waiting for subsequent messages under this refID,
               // so we aren't releasing this particular refID
            }
            else
               this.refIDs[ refID ] = null; // if it's not boolean, id will be released

         }   
         else
            this.refIDs[ refID ] = null;
            
         // amfioEvent.result = response;
      }
      else
      {
         // amfioEvent.result = "Checksum error";
      }
      //this.dispatchEvent(amfioEvent);

   }

   this.procExists = function( procname )
   {
      return this.sendPacket( AMFIO_PROCEXISTS, null, procname );      
   }

   this.procExec = function( procname /*, ... args */ )
   {
      var args = Array.prototype.slice.call( arguments );
      args.splice( 0, 0, AMFIO_PROCEXEC, null, procname );
      this.sendPacket.apply( this, args );
   }

   this.funcExec = function( procname /*, ... args */ )
   {
      var args = Array.prototype.slice.call( arguments );

      if( args.length >= 2 && 'function' === typeof args[1] )
      {
         args[0] = args[1];
         args[1] = procname;         
         args.splice( 0, 0, AMFIO_FUNCEXEC );
      }
      else
         args.splice( 0, 0, AMFIO_FUNCEXEC, null );      

      this.sendPacket.apply( this, args );
   }

   this.str2AB = function( str )
   {
      var bytes = new Uint8Array( str.length );

      for( var i = 0; i < str.length; i++ ) {
         bytes[ i ] = str.charCodeAt( i );
      }

      return bytes.buffer;
   }

   this.AB2str = function( ab )
   {
      var bytes = new Uint8Array( ab );
      var str = '';

      for( var i = 0; i < bytes.length; i++ ) {
         str += String.fromCharCode( bytes[ i ] );
      }

      return str;
   }
}
   

/* to be ported to JS

      public function objectNew( classname:String, responder:* = null, ... args ):void
      {
         args.splice( 0, 0, AMFIO_OBJECTNEW, responder, classname );
         sendPacket.apply( this, args );
      }
      
      public function objectDel( objectid:int ):void
      {
         if( this._selectedObjectID == objectid )
            this._selectedObjectID = 0;
         sendPacket( AMFIO_OBJECTDEL, null, objectid );
      }
      
      public function objectWith( objectid:int ):void
      {
         this._selectedObjectID = objectid;
         sendPacket( AMFIO_OBJECTWITH, null, objectid );      
      }
      
      public function objectSend( methodname:String, ... args ):void
      {
         if(args.length >= 1 && args[0] is Function)
         {
            var responder:Function = args[0];
            args.shift();
            args.splice( 0, 0, AMFIO_OBJECTSEND, responder, methodname );         
         }
         else
         {
            args.splice( 0, 0, AMFIO_OBJECTSEND, null, methodname );
         }
         sendPacket.apply( this, args );
      }
      
      public function objectGetV( xMsgList:*, responder:* = null ):void
      {         
         sendPacket( AMFIO_OBJECTGETV, responder, xMsgList );
      }
     
*/    
