var socket; // Websocket instance
var amfio; // AmfIO instance

function printFuncs( aFuncs )
{
   var lbFuncs = document.getElementById('lbFuncs');
   lbFuncs.selectedIndex = -1; 
   lbFuncs.options.length = 0;
   for( var i = 0; i < aFuncs.length; i++ ) 
   {
     var oOpt = new Option( aFuncs[ i ], aFuncs[ i ] );
     lbFuncs.options.add( oOpt );
   }
   lbFuncs.options = aFuncs;
   return true;
}

function printTime( uValue )
{
   var time_output = document.getElementById('time_output');
   time_output.innerHTML = uValue;
   return false; // inform amfio to not release our job reference id for our timer
}

function execute()
{
   var cParams = document.getElementById('tbParams').value;
   var uValue;
   var lbFuncs = document.getElementById('lbFuncs');

   if( lbFuncs.selectedIndex > -1 && lbFuncs.options[ lbFuncs.selectedIndex ].value == "TIMER" )
   {
      amfio.funcExec( "TIMER", printTime );
      return;
   }

   if( cParams.length > 0 )
   {

      try
      {
         uValue = eval( cParams );
      }
      catch( error )
      {
         output.innerHTML = "JS eval() " + error;
         uValue = null;
         return;
      }

   }

   if( lbFuncs.selectedIndex > -1 )
   {
      if( !uValue || !( 'function' === typeof uValue.push ) ) // check if eval() result isn't array already
         uValue = [ uValue ];

      uValue.splice( 0, 0, lbFuncs.options[ lbFuncs.selectedIndex ].value, printOutput );
      amfio.funcExec.apply( amfio, uValue );
   }  
}

function echo48()
{
   var text = "";
   var c = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";

   for( var i=0; i < 49152; i++ )
       text += c.charAt( Math.floor( Math.random() * c.length ) );

   amfio.funcExec( "ECHO", printOutput, text );
}

function printOutput( result )
{
   var output = document.getElementById('output');
   output.innerHTML = "result data type: " + ( typeof result ) + "<br>" + result;
   return true;
}

function connect( cServer )
{
   try
   {

      socket = new WebSocket( cServer );

      socket.onopen = function( event )
      {
	alert('Connected');
        amfio = new AmfIO( socket );
        socket.addEventListener("message", onmessage );
        amfio.funcExec('LISTFUNCS', printFuncs ) // if the second argument is JavaScript function
                                      // it will receive the return value, anything else
                                      // put as a second argument, it's being sent
                                      // as parameter to the server, and no value
                                      // is received
      }

      socket.onmessage = function( msg )
      {
	 amfio.processPacket( msg.data );
      }

      socket.onclose = function( event )
      {
         socket.removeEventListener("message", amfio.processPacket );
         alert("connection closed from the server") ;
      }

      socket.onerror = function()
      {
         alert( "Error: " + socket.readyState );
      }
   }
   catch( exception )
   {
      alert( "Exception occurred" );
   }

}

function disconnect()
{
   try
   {
      socket.close();
      alert('Disconnected');

      var lbFuncs = document.getElementById('lbFuncs');
      lbFuncs.selectedIndex = -1; 
      lbFuncs.options.length = 0;
   }
   catch( exception )
   {
      alert( "can't close connection" );
   }
}
