/*******
 *
 *  wsbin.c by Aleksander Czajczynski <hb/at/fki.pl> 2012
 *
 *  wsbin.c - Generic functions for processing binary data
 *
 ********/

#include "hbapi.h"
#include "hbapiitm.h"

static HB_UCHAR _xor_chr( const char * szData, int iLen )
{
   HB_UCHAR iChecksum   = 0;
   int      i           = 0;

   if( szData )
   {
      for( i = 0; i < iLen; i++ )
      {
         iChecksum = iChecksum ^ ( HB_UCHAR ) szData[ i ];
      }
   }

   return iChecksum;
}

HB_FUNC( XORCHECK )
{
   HB_BOOL        fResult  = HB_FALSE;

   const char *   szData   = hb_parc( 1 );
   const char *   szChk    = hb_parc( 2 );

   if( szData && szChk )
   {
      int      iLen  = hb_parclen( 1 );
      HB_UCHAR iChk  = ( HB_UCHAR ) szChk[ 0 ];

      if( _xor_chr( szData, iLen ) == iChk )
      {
         fResult = HB_TRUE;
      }
   }

   hb_retl( fResult );
}

HB_FUNC( XORCOUNT )
{
   const char * szData = hb_parc( 1 );

   if( szData )
   {
      int      iLen  = hb_parclen( 1 );
      char *   pRet  = ( char * ) hb_xgrab( 2 );

      pRet[ 0 ] = _xor_chr( szData, iLen );

      hb_retclen_buffer( pRet, 1 );
   }
}

HB_FUNC( BEBIN2U )
{
   PHB_ITEM pItem = hb_param( 1, HB_IT_STRING );

   if( pItem )
   {
      HB_SIZE nLen = hb_itemGetCLen( pItem );
      if( nLen )
      {
         const char * pszString = hb_itemGetCPtr( pItem );
         if( nLen >= 5 )
         {
            hb_retnint( HB_GET_BE_UINT64( pszString ) );
         }
         if( nLen >= 3 )
            hb_retnint( HB_GET_BE_UINT32( pszString ) );
         else
            hb_retnint( HB_GET_BE_UINT16( pszString ) );
      }
   }
   else
      hb_retnint( 0 );
}

HB_FUNC( BEU2BIN )
{
   char     szResult[ 4 ];
   HB_U32   uiValue = ( HB_U32 ) hb_parnint( 1 );

   HB_PUT_BE_UINT32( szResult, uiValue );
   hb_retclen( szResult, 4 );
}

HB_FUNC( BEW2BIN )
{
   char     szResult[ 2 ];
   HB_U16   uiValue = ( HB_U16 ) hb_parni( 1 );

   HB_PUT_BE_UINT16( szResult, uiValue );
   hb_retclen( szResult, 2 );
}

/* following are really identical to hbxpp's U2Bin(), W2Bin(), Bin2U() */

HB_FUNC( LEBIN2U )
{
   PHB_ITEM pItem    = hb_param( 1, HB_IT_STRING );
   HB_U32   uiResult = 0;

   if( pItem )
   {
      HB_SIZE nLen = hb_itemGetCLen( pItem );
      if( nLen )
      {
         const char * pszString = hb_itemGetCPtr( pItem );
         if( nLen >= 3 )
            uiResult = HB_GET_LE_UINT32( pszString );
         else
            uiResult = HB_GET_LE_UINT16( pszString );
      }
   }
   hb_retnint( uiResult );
}

HB_FUNC( LEU2BIN )
{
   char     szResult[ 4 ];
   HB_U32   uiValue = ( HB_U32 ) hb_parnint( 1 );

   HB_PUT_LE_UINT32( szResult, uiValue );
   hb_retclen( szResult, 4 );
}

HB_FUNC( LEW2BIN )
{
   char     szResult[ 2 ];
   HB_U16   uiValue = ( HB_U16 ) hb_parni( 1 );

   HB_PUT_LE_UINT16( szResult, uiValue );
   hb_retclen( szResult, 2 );
}
